import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Define colors
ingredient1_color = 'red'
ingredient2_color = 'blue'
cocktail1_color = 'purple'  # Mix of ingredient2 (part1) and ingredient1 (part2)
cocktail2_color = 'magenta'  # Mix of ingredient1 (part1) and ingredient2 (part2)
clean_empty_color = 'lightgrey'
hand_empty_color = 'whitesmoke'
text_color = 'black'

# Add dispensers
ax.add_patch(patches.Rectangle((0.5, 8), 2, 1, edgecolor='black', facecolor=ingredient1_color))
ax.text(1.5, 8.5, 'dispenser_1\n(ingredient1)', color=text_color, ha='center', va='center', fontsize=8)

ax.add_patch(patches.Rectangle((6.5, 8), 2, 1, edgecolor='black', facecolor=ingredient2_color))
ax.text(7.5, 8.5, 'dispenser_2\n(ingredient2)', color=text_color, ha='center', va='center', fontsize=8)

# Add shots with cocktails
ax.add_patch(patches.Rectangle((0.5, 5), 1, 1, edgecolor='black', facecolor=cocktail2_color))
ax.text(1, 5.5, 'shot_1\ncocktail2', color=text_color, ha='center', va='center', fontsize=8)

ax.add_patch(patches.Rectangle((4.5, 5), 1, 1, edgecolor='black', facecolor=cocktail1_color))
ax.text(5, 5.5, 'shot_2\ncocktail1', color=text_color, ha='center', va='center', fontsize=8)

# Add shot3 without constraints
ax.add_patch(patches.Rectangle((8.5, 1), 1, 1, edgecolor='black', facecolor=clean_empty_color))
ax.text(9, 1.25, 'shot_3\nno constraints', color=text_color, ha='center', va='center', fontsize=8)

# Add shaker1 without constraints
ax.add_patch(patches.Circle((5, 1), 0.75, edgecolor='black', facecolor=clean_empty_color))
ax.text(5, 1, 'shaker_1\nno constraints', color=text_color, ha='center', va='center', fontsize=8)

# Add hands without constraints
ax.add_patch(patches.Rectangle((0.5, 0), 1, 0.5, edgecolor='black', facecolor=hand_empty_color))
ax.text(1, 0.25, 'left_hand\nno constraints', color=text_color, ha='center', va='center', fontsize=8)

ax.add_patch(patches.Rectangle((8.5, 0), 1, 0.5, edgecolor='black', facecolor=hand_empty_color))
ax.text(9, 0.25, 'right_hand\nno constraints', color=text_color, ha='center', va='center', fontsize=8)

# Add legend
legend_elements = [
    patches.Patch(facecolor=ingredient1_color, edgecolor='black', label='ingredient1'),
    patches.Patch(facecolor=ingredient2_color, edgecolor='black', label='ingredient2'),
    patches.Patch(facecolor=cocktail1_color, edgecolor='black', label='cocktail1 (ingredient2 + ingredient1)'),
    patches.Patch(facecolor=cocktail2_color, edgecolor='black', label='cocktail2 (ingredient1 + ingredient2)'),
    patches.Patch(facecolor=clean_empty_color, edgecolor='black', label='no constraints'),
    patches.Patch(facecolor=hand_empty_color, edgecolor='black', label='hand empty')
]
ax.legend(handles=legend_elements, loc='upper right', fontsize=8)

# Set limits and hide axes
ax.set_xlim(0, 10)
ax.set_ylim(0, 10)
ax.axis('off')

# Save the figure
plt.savefig('barman/one_shot/goal_diagram_code/attempts/goal_diagram_attempt_5.png')
plt.show()